<?php
/**
 * Template part for displaying header two
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Raise_Mag
 */
?>
<header id="mastheader" class="mastheader header_style2">
    <div class="header_top">
        <div class="ab_container">
            <div class="header_top_entry">
                <div class="row">
                    <div class="col nav_col">
                        <nav class="main_navigation">
                            <?php 
                            /**
                             * Hook - raise_mag_main_menu.
                             *
                             * @hooked raise_mag_main_menu_action - 1
                             */
                            do_action( 'raise_mag_main_menu' ); 
                            ?>
                        </nav><!-- .main_navigation -->
                    </div><!-- .col.nav_col -->

                    <?php 
                    /**
                     * Hook - raise_mag_header_social_links.
                     *
                     * @hooked raise_mag_header_social_links_action - 1
                     */
                    do_action( 'raise_mag_header_social_links' ); 
                    ?>

                </div><!-- .row -->
            </div><!-- .header_top_entry -->
        </div><!-- .ab_container -->
    </div><!-- .header_top -->
    <div class="site_idty_wrap">
        <div class="ab_container">
            <div class="row">
                <div class="col left_col">
                    <?php 
                    /**
                     * Hook - raise_mag_logo.
                     *
                     * @hooked raise_mag_logo_action - 1
                     */
                    do_action( 'raise_mag_logo' ); 
                    ?>
                </div><!-- .col -->
                <?php if( is_active_sidebar( 'header-advertisement' ) ) : ?>
                <div class="col right_col">
                    <?php dynamic_sidebar( 'header-advertisement' ); ?>
                </div><!-- .col.right_col -->
                <?php endif; ?>
            </div><!-- .row -->
        </div><!-- .ab_container -->
    </div><!-- .site_idty_wrap -->
</header><!-- #mastheader.mastheader.header_style2 -->