<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Raise_Mag
 */

get_header();

raise_mag_banner_template();
?>
	<div class="ab_container">
		
		<div class="mid_portion_wrap frontpage_mid_wrap <?php echo esc_attr( raise_mag_main_post_list_class() ); ?>">
            <div class="row">
            	<?php raise_mag_global_left_sidebar(); ?>
                <div class="<?php echo esc_attr( raise_mag_post_list_class() ); ?>">
                	<div id="content" class="site-content">
                    <div id="primary" class="content-area">
                        <main id="main" class="site-main">
	                        <?php
							if( have_posts() ) {
								$sidebar_position = get_theme_mod( 'raise_mag_global_sidebar_position', 'right' );
								if( $sidebar_position != 'none' && is_active_sidebar( 'sidebar' ) ) {
									get_template_part( 'template-parts/layout/layout', 'grid' );
								} else {
									get_template_part( 'template-parts/layout/layout', 'gridfull' );
								}
							} else {
								get_template_part( 'template-parts/content', 'none' );
							}
							?>
						</main><!-- #main.site-main -->
					</div><!-- #primary.content-area -->
				</div><!-- // site-content -->
				</div><!--  -->
				<?php raise_mag_global_right_sidebar(); ?>
			</div><!-- .row -->
		</div><!-- .mid_portion_wrap.frontpage_mid_wrap -->
	</div><!-- .ab_container -->
<?php
get_footer();
