<?php
/**
 * Init all the widgets for theme
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Raise_Mag
 */


require RAISE_MAG_INC_DIR . 'theme-widgets/widget-author.php';
require RAISE_MAG_INC_DIR . 'theme-widgets/widget-post.php';


if ( ! function_exists( 'raise_mag_admin_scripts' ) ) {

    function raise_mag_admin_scripts( $hook ) {

        if ( 'widgets.php' == $hook || is_admin() ) {

        	wp_enqueue_script( 'media-upload' );

			wp_enqueue_media();

			wp_enqueue_style( 'raise-mag-admin-widget', get_template_directory_uri() . '/assets/admin/css/admin-widget.css' );

			wp_enqueue_script( 'raise-mag-admin-widget', get_template_directory_uri() . '/assets/admin/js/admin-widget.js', array( 'jquery' ), '1.0.0' );
		}
    }
}
add_action('admin_enqueue_scripts', 'raise_mag_admin_scripts');

/**
 * Register widgets.
 *
 */
function raise_mag_register_widgets() {

	register_widget( 'Raise_Mag_Author_Widget' );

	register_widget( 'Raise_Mag_Post_Widget' );
}
add_action( 'widgets_init', 'raise_mag_register_widgets' );
