<?php
/**
 * Raise Mag functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Raise_Mag
 */

 /**
 * Function for Register sidebar area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function raise_mag_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'raise-mag' ),
		'id'            => 'sidebar',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="widget"><div class="%2$s">',
		'after_widget'  => '</div></div>',
		'before_title'  => '<div class="widget-title"><h3>',
		'after_title'   => '</h3></div>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer', 'raise-mag' ),
		'id'            => 'footer',
		'description'   => '',
		'before_widget' => '<div class="col-md-4 col-sm-12 col-xs-12"><div id="%1$s" class="widget"><div class="%2$s">',
		'after_widget'  => '</div></div></div>',
		'before_title'  => '<div class="widget-title"><h3>',
		'after_title'   => '</h3></div>',
	) );

	if( get_theme_mod( 'raise_mag_header_layout', 'header_one' ) == 'header_one' ) {
		register_sidebar( array(
			'name'          => esc_html__( 'Header Advertisement', 'raise-mag' ),
			'id'            => 'header-advertisement',
			'description'   => '',
			'before_widget' => '<div id="%1$s" class="widget"><div class="advt_widget %2$s">',
			'after_widget'  => '</div></div>',
			'before_title'  => '',
			'after_title'   => '',
		) );
	}
	
}
add_action( 'widgets_init', 'raise_mag_widgets_init' );