<?php
/**
 * Init all the includes files for theme
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Raise_Mag
 */
/**
 * Enqueue scripts and styles.
 */

 function raise_mag_scripts() {
	
	wp_enqueue_style( 'raise-mag-style', get_stylesheet_uri() );

	wp_enqueue_style( 'raise-mag-font', raise_mag_fonts_url() );

	wp_enqueue_style( 'raise-mag-main', get_template_directory_uri() . '/assets/dist/css/main.css' );

	wp_enqueue_script( 'raise-mag-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '1.0.0', true );

	wp_enqueue_script( 'raise-mag-bundle', get_template_directory_uri() . '/assets/dist/js/bundle.min.js', array( 'jquery', 'masonry' ), '1.0.0', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'raise_mag_scripts' );