<?php
/**
 * All singular hooks for theme.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Raise_Mag
 */

/**
 * Page links hook declaration
 *
 * @since 1.0.0
 */
if( ! function_exists( 'raise_mag_page_links_action' ) ) :

 	function raise_mag_page_links_action() {

        wp_link_pages( array(
			'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'raise-mag' ),
			'after'  => '</div>',
		) );
    }
endif;
add_action( 'raise_mag_page_links', 'raise_mag_page_links_action', 400 );

/**
 * Edit post link hook declaration
 *
 * @since 1.0.0
 */
if( ! function_exists( 'raise_mag_edit_post_links_action' ) ) :

 	function raise_mag_edit_post_links_action() {

        if ( get_edit_post_link() ) :

			edit_post_link(
				sprintf(
					wp_kses(
						/* translators: %s: Name of current post. Only visible to screen readers */
						__( 'Edit <span class="screen-reader-text">%s</span>', 'raise-mag' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					get_the_title()
				),
				'<span class="edit-link">',
				'</span>'
			);
	   endif;
    }
endif;
add_action( 'raise_mag_edit_post_links', 'raise_mag_edit_post_links_action', 405 );

/**
 * Post navigation hook declaration
 *
 * @since 1.0.0
 */
if( ! function_exists( 'raise_mag_post_navigation_action' ) ) :

 	function raise_mag_post_navigation_action() {

        if ( 'post' === get_post_type() ) :

            $next_post = get_next_post();

            $previous_post = get_previous_post();

            ?>
            <div class="post-navigation">
                <div class="nav-links">
                  <?php
                   if (!empty( $previous_post )):
                    ?>
                    <div class="nav-previous">
                        <span><?php echo esc_html__( 'Prev post', 'raise-mag' ); ?></span>
                        <a href="<?php echo esc_url( get_permalink( $previous_post->ID ) ); ?>"><?php echo esc_html( $previous_post->post_title ); ?></a>
                    </div>
                    <?php
                    endif;

                   if (!empty( $next_post )):
                    ?>
                    <div class="nav-next">
                        <span><?php echo esc_html__( 'Next post', 'raise-mag' ); ?></span>
                        <a href="<?php echo esc_url( get_permalink( $next_post->ID ) ); ?>"><?php echo esc_html( $next_post->post_title ); ?></a>
                    </div>
                    <?php
                    endif;
                    ?>
                </div><!-- // nav-links -->
            </div><!-- // post-navigation -->
            <?php
        endif;
    }
endif;
add_action( 'raise_mag_post_navigation', 'raise_mag_post_navigation_action', 410 );

/**
 * Post author hook declaration
 *
 * @since 1.0.0
 */
if( ! function_exists( 'raise_mag_post_author_action' ) ) :

 	function raise_mag_post_author_action() {

        ?>
        <div class="author-box">
            <div class="top-wrap clearfix">
                <div class="author-thumb">
                    <?php echo get_avatar( get_the_author_meta( 'ID' ), 300 ); ?>
                </div>
                <div class="author-name">
                    <h3><?php echo esc_html( get_the_author() ); ?></h3>
                    <?php
                    $author_description = get_the_author_meta( 'description' );

                    if( !empty( $author_description ) ) {

                        ?>
                        <p class="author-details"><?php echo esc_html( $author_description ); ?></p>
                        <?php
                    }
                    ?>
                </div>
            </div>
        </div><!-- // author-box -->
        <?php
    }
endif;
add_action( 'raise_mag_post_author', 'raise_mag_post_author_action', 415 );

/**
 * Related post hook declaration
 *
 * @since 1.0.0
 */
if( ! function_exists( 'raise_mag_related_post_action' ) ) :

 	function raise_mag_related_post_action() {

        $related_posts_query = raise_mag_related_posts_query();

        if( $related_posts_query->have_posts() ) {

            ?>
            <div class="bs-related-post">
                <div class="title_sec text-center"><small><?php esc_html_e( 'Posts', 'raise-mag' ); ?></small>
                    <h3><?php esc_html_e( 'Related posts', 'raise-mag' ); ?></h3>
                </div>
                <div class="bs-row">
                <?php

                while( $related_posts_query->have_posts() ) :

                    $related_posts_query->the_post();

                    ?>
                    <div class="bs-col">
                        <div class="hentry">
                            <div class="bs-full-widget-area post-fobsat-block">
                                <div class="img-holder">
                                    <figure class="thumb is-standard">
                                        <a href="<?php the_permalink(); ?>">
                                            <?php

                                            the_post_thumbnail( 'raise-mag-thumbnail-two', array( 'alt' => the_title_attribute( array( 'echo' => false ) ) ) );

                                            ?>
                                        </a>
                                    </figure><!-- // thumb -->
                                </div>
                                <div class="bs-widget-content">
                                    <div class="widget-inn-tt">
                                        <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                    </div>
                                    <div class="entry-metas">
                                        <ul>
                                            <?php raise_mag_posted_on( true ); ?>
                                            <?php raise_mag_comments_no( true ); ?>
                                            <?php raise_mag_views_meta( true ); ?>
                                        </ul>
                                    </div>
                                    <!--full-widget-area-->
                                    <?php the_excerpt(); ?>
                                </div>
                                <!--bs-widget-content-->
                            </div>
                        </div>
                    </div><!-- // bs-col -->
                    <?php
                endwhile;
                wp_reset_postdata();
                ?>
                </div><!-- // bs-row -->
            </div><!--related-post-->
            <?php
        }
    }
endif;
add_action( 'raise_mag_related_post', 'raise_mag_related_post_action', 420 );
