<?php
/**
 * Custom Hooks
 *
 * @package Raise_Mag
 */

if( !function_exists( 'raise_mag_main_menu_action' ) ) {
    /**
     * Hook - Main Menu
     *
     * @since 1.0.0
     */
    function raise_mag_main_menu_action() {
        $menu_class = null;
        $header_layout = get_theme_mod( 'raise_mag_header_layout', 'header_one' );
        if( $header_layout == 'header_three' || $header_layout == 'header_four' ) {
            $menu_class = 'has_search';
        }
        ?>
        <div class="primary_navigation has_search <?php echo esc_attr( $menu_class ); ?>">
            <?php
                wp_nav_menu( array( 
                    'theme_location'    => 'main-menu',
                    'container'         => '',
                    'fallback_cb'       => 'raise_mag_navigation_fallback',
                 ) );
            ?>
        </div><!-- .primary_navigation -->
        <?php
    }
}
add_action( 'raise_mag_main_menu', 'raise_mag_main_menu_action', 1 );

if( !function_exists( 'raise_mag_menu_search_action' ) ) {
	/**
     * Hook - Main Menu
     *
     * @since 1.0.0
     */
	function raise_mag_menu_search_action() {
		?>
		<div class="header_search">
            <?php get_search_form(); ?>
        </div><!-- .header_search -->
		<?php
	}
}
add_action( 'raise_mag_menu_search', 'raise_mag_menu_search_action', 1 );


if( !function_exists( 'raise_mag_header_menu_action' ) ) {
	/**
     * Hook - Header Menu
     *
     * @since 1.0.0
     */
	function raise_mag_header_menu_action() {
		if( has_nav_menu( 'header-menu' ) ) :
			?>
			<div class="col nav_col">
				<div class="secondary_nav">
		            <?php
		            	wp_nav_menu( array( 
		        			'theme_location' 	=> 'header-menu',
		        			'container'			=> '',
		        		 ) );
		            ?>
		        </div><!-- .secondary_nav -->
		    </div><!-- .col.nav_col -->
			<?php
		endif;
	}
}
add_action( 'raise_mag_header_menu', 'raise_mag_header_menu_action', 1 );


if( !function_exists( 'raise_mag_header_social_links_action' ) ) {
	/**
     * Hook - Header Social Links
     *
     * @since 1.0.0
     */
	function raise_mag_header_social_links_action() {
		?>
		<div class="col">
            <div class="header_extra">
                <div class="social">
                    <ul class="social_icons_list">
                    	<?php 
                        $facebook_link = get_theme_mod( 'raise_mag_facebook_link', '' );
                        if( !empty( $facebook_link ) ) : ?>
                        <li><a href="<?php echo esc_url( $facebook_link ); ?>"><i class="fa fa-facebook" aria-hidden="true"></i></a></li>
                        <?php endif; ?>
                        <?php
                        $twitter_link = get_theme_mod( 'raise_mag_twitter_link', '' );
                        if( !empty( $twitter_link ) ) : ?>
                        <li><a href="<?php echo esc_url( $twitter_link ); ?>"><i class="fa fa-twitter" aria-hidden="true"></i></a></li>
                        <?php endif; ?>
                        <?php 
                        $googleplus_link = get_theme_mod( 'raise_mag_google_plus_link', '' );
                        if( !empty( $googleplus_link ) ) : ?>
                        <li><a href="<?php echo esc_url( $googleplus_link ); ?>"><i class="fa fa-google-plus" aria-hidden="true"></i></a></li>
                        <?php endif; ?>
                        <?php 
                        $pinterest_link = get_theme_mod( 'raise_mag_pinterest_link', '' );
                        if( !empty( $pinterest_link ) ) : ?>
                        <li><a href="<?php echo esc_url( $pinterest_link ); ?>"><i class="fa fa-pinterest" aria-hidden="true"></i></a></li>
                        <?php endif; ?>
                        <?php 
                        $instagram_link = get_theme_mod( 'raise_mag_instagram_link', '' );
                        if( !empty( $instagram_link ) ) : ?>
                        <li><a href="<?php echo esc_url( $instagram_link ); ?>"><i class="fa fa-instagram" aria-hidden="true"></i></a></li>
                        <?php endif; ?>
                        <?php 
                        $vk_link = get_theme_mod( 'raise_mag_vk_link', '' );
                        if( !empty( $vk_link ) ) : ?>
                        <li><a href="<?php echo esc_url( $vk_link ); ?>"><i class="fa fa-vk" aria-hidden="true"></i></a></li>
                        <?php endif; ?>
                        <?php 
                        $youtube_link = get_theme_mod( 'raise_mag_youtube_link', '' );
                        if( !empty( $youtube_link ) ) : ?>
                        <li><a href="<?php echo esc_url( $youtube_link ); ?>"><i class="fa fa-youtube" aria-hidden="true"></i></a></li>
                        <?php endif; ?>
                    </ul><!-- .social_icons_list -->
                </div><!-- .social_icons -->
            </div><!-- .header_extra -->
        </div><!-- .col -->
		<?php
	}
}
add_action( 'raise_mag_header_social_links', 'raise_mag_header_social_links_action', 1 );


if( !function_exists( 'raise_mag_logo_action' ) ) {
    /**
     * Hook - Logo
     *
     * @since 1.0.0
     */
    function raise_mag_logo_action() {
        ?>
        <div class="site_idty_entry">
            <div class="logo">
                <?php if( has_custom_logo() ) : the_custom_logo(); else : ?>
                <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                <?php 
                $raise_mag_description = get_bloginfo( 'description', 'display' );
                if ( $raise_mag_description || is_customize_preview() ) :
                ?>
                <p class="site-description"><?php echo esc_html( $raise_mag_description ); /* WPCS: xss ok. */ ?></p>
                <?php endif; endif; ?>
            </div><!-- .logo -->
        </div><!-- .site_idty_entry -->
        <?php
    }
}
add_action( 'raise_mag_logo', 'raise_mag_logo_action', 1 );