<?php
/**
 * All Copyright Text hooks for theme.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Raise_Mag
 */

if( !function_exists( 'raise_mag_copyright_text_action' ) ) {
	
	function raise_mag_copyright_text_action() {
		$copyright_text = get_theme_mod( 'raise_mag_copyright_text', '' );        
		?>
		<div class="col left_col">
            <div class="copyright">
                <p>
                    <?php 
                    if( !empty( $copyright_text ) ) {
                        /* translators: 1: Copyright Text, 2: Theme Name, 3:  Theme Author URL. */
                        printf( esc_html__( '%1$s %2$s Theme By %3$s ', 'raise-mag' ), $copyright_text, 'Raise Mag', '<a href="' . esc_url( 'https://wishfulthemes.com' ) . '" target="_blank">' . esc_html__( 'WishfulThemes', 'raise-mag') . '</a>' );
                    } else {
                        /* translators: 1: Theme Author URL. */
                        printf( esc_html__( '%1$s Theme By %2$s ', 'raise-mag' ), 'Raise Mag', '<a href="' . esc_url( 'https://wishfulthemes.com' ) . '" target="_blank">' . esc_html__( 'WishfulThemes', 'raise-mag') . '</a>' );
                    }
                    ?>
                </p>
            </div><!-- .copyright -->
        </div><!-- .col.left_col -->
		<?php
	}
}
add_action( 'raise_mag_copyright_text', 'raise_mag_copyright_text_action', 1 );

if( !function_exists( 'raise_mag_footer_menu_action' ) ) {
	/**
     * Hook - Footer Menu
     *
     * @since 1.0.0
     */
	function raise_mag_footer_menu_action() {
		if( has_nav_menu( 'footer-menu' ) ) :
			?>
			<div class="col right_col">
				<div class="footer_nav">
		            <?php
		            	wp_nav_menu( array( 
		        			'theme_location' 	=> 'footer-menu',
		        			'container'			=> '',
		        		 ) );
		            ?>
		        </div><!-- .footer_nav -->
		    </div><!-- .col.right_col -->
			<?php
		endif;
	}
}
add_action( 'raise_mag_footer_menu', 'raise_mag_footer_menu_action', 1 );