<?php
/**
 * Query functions required by theme
 *
 * @package Raise_Mag
 */


if( !function_exists( 'raise_mag_related_posts_query' ) ) :

    function raise_mag_related_posts_query() {

        $related_posts_section_post_no = absint( 3 );

        $related_posts_query_args = array(
            'no_found_rows'       => true,
            'ignore_sticky_posts' => true,
        );

        if( absint( $related_posts_section_post_no ) > 0 ) {

            $related_posts_query_args['posts_per_page'] = absint( $related_posts_section_post_no );

        } else {

            $related_posts_query_args['posts_per_page'] = 3;
        }

        $current_object = get_queried_object();

        if ( $current_object instanceof WP_Post ) {

            $current_id = $current_object->ID;

            if ( absint( $current_id ) > 0 ) {

                // Exclude current post.
                $related_posts_query_args['post__not_in'] = array( absint( $current_id ) );

                // Include current posts categories.
                $categories = wp_get_post_categories( $current_id );

                if ( ! empty( $categories ) ) {

                    $related_posts_query_args['tax_query'] = array(
                        array(
                            'taxonomy' => 'category',
                            'field'    => 'term_id',
                            'terms'    => $categories,
                            'operator' => 'IN',
                        )
                    );
                }
            }
        }

        $related_posts_query = new WP_Query( $related_posts_query_args );

        return $related_posts_query;
    }
endif;
