<?php
/**
 * Raise Mag Theme Customizer
 *
 * @package Raise_Mag
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function raise_mag_customize_register( $wp_customize ) {

	require_once get_template_directory() . '/inc/theme-customizer/upgrade-to-pro/upgrade.php';

	if ( class_exists( 'Raise_Mag_Customize_Section_Upsell' ) ) {
		$wp_customize->register_section_type( 'Raise_Mag_Customize_Section_Upsell' );

		$wp_customize->add_section(
			new Raise_Mag_Customize_Section_Upsell(
				$wp_customize,
				'raise_mag_pro',
				array(
					'title'       => esc_html__( 'Raise Mag Pro', 'raise-mag' ),
					'button_text' => esc_html__( 'Buy Pro', 'raise-mag' ),
					'button_url'  => 'https://www.wishfulthemes.com/themes/raise-mag-pro/',
					'priority'    => 1,
				)
			)
		);
	}

	/**
	 * Custom Customize Control
	 */
	require get_template_directory() . '/inc/theme-customizer/customize-controls.php';

	/**
	 * Sanitization Functions
	 */
	require get_template_directory() . '/inc/theme-customizer/sanitize-callback.php';

	/**
	 * Customizer Options
	 */
	require get_template_directory() . '/inc/theme-customizer/customizer-options.php';

	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'blogname',
			array(
				'selector'        => '.site-title a',
				'render_callback' => 'raise_mag_customize_partial_blogname',
			)
		);
		$wp_customize->selective_refresh->add_partial(
			'blogdescription',
			array(
				'selector'        => '.site-description',
				'render_callback' => 'raise_mag_customize_partial_blogdescription',
			)
		);
	}

}
add_action( 'customize_register', 'raise_mag_customize_register' );

/**
 * Load Customizer Option Choices
 */
require get_template_directory() . '/inc/theme-customizer/option-choices.php';

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function raise_mag_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function raise_mag_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function raise_mag_customize_preview_js() {
	wp_enqueue_script( 'raise-mag-customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'raise_mag_customize_preview_js' );



/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function raise_mag_customizer_script() {
	wp_enqueue_style( 'chosen', get_template_directory_uri() . '/assets/admin/css/chosen.css' );
	wp_enqueue_style( 'raise-mag-custom', get_template_directory_uri() . '/assets/admin/css/custom.css' );
	wp_enqueue_script( 'chosen-jquery', get_template_directory_uri() . '/assets/admin/js/chosen.jquery.js', array( 'jquery' ), '1.8.3', true );
	wp_enqueue_script( 'raise-mag-custom', get_template_directory_uri() . '/assets/admin/js/custom.js', array( 'jquery' ), '1.0.0', true );

	wp_enqueue_style( 'raise-mag-upsell', get_template_directory_uri() . '/inc/theme-customizer/upgrade-to-pro/upgrade.css', array(), '1.0.0', 'all' );
	wp_enqueue_script( 'raise-mag-upsell', get_template_directory_uri() . '/inc/theme-customizer/upgrade-to-pro/upgrade.js', array( 'jquery' ), '1.0.0', true );
}
add_action( 'customize_controls_enqueue_scripts', 'raise_mag_customizer_script' );
