<?php
/**
 * Customizer Options Declaration
 *
 * @package Raise_Mag
 */

/*
-----------------------------------------------------------------------------
							HEADER SECTION OPTIONS
-----------------------------------------------------------------------------*/

// Section - Header
$wp_customize->add_section(
	'raise_mag_header_options',
	array(
		'priority' => 20,
		'title'    => esc_html__( 'Header Section', 'raise-mag' ),
	)
);

// Option - Header Layout
$wp_customize->add_setting(
	'raise_mag_header_layout',
	array(
		'sanitize_callback' => 'raise_mag_sanitize_select',
		'default'           => 'header_one',
	)
);

$wp_customize->add_control(
	'raise_mag_header_layout',
	array(
		'label'   => esc_html__( 'Select Header Layout', 'raise-mag' ),
		'section' => 'raise_mag_header_options',
		'type'    => 'select',
		'choices' => array(
			'header_one' => esc_html__( 'Header Layout One', 'raise-mag' ),
			'header_two' => esc_html__( 'Header Layout Two', 'raise-mag' ),
		),
	)
);

/*
-----------------------------------------------------------------------------
							BANNER SECTION OPTIONS
-----------------------------------------------------------------------------*/

// Section - Banner
$wp_customize->add_section(
	'raise_mag_banner_options',
	array(
		'priority' => 20,
		'title'    => esc_html__( 'Banner Section', 'raise-mag' ),
	)
);

// Option - Enable Banner Section
$wp_customize->add_setting(
	'raise_mag_enable_banner',
	array(
		'sanitize_callback' => 'raise_mag_sanitize_checkbox',
		'default'           => 0,
	)
);

$wp_customize->add_control(
	'raise_mag_enable_banner',
	array(
		'label'   => esc_html__( 'Enable Banner Section', 'raise-mag' ),
		'section' => 'raise_mag_banner_options',
		'type'    => 'checkbox',
	)
);

// Option - Banner Layout
$wp_customize->add_setting(
	'raise_mag_banner_layout',
	array(
		'sanitize_callback' => 'raise_mag_sanitize_select',
		'default'           => 'banner_one',
	)
);

$wp_customize->add_control(
	'raise_mag_banner_layout',
	array(
		'label'           => esc_html__( 'Select Banner Layout', 'raise-mag' ),
		'section'         => 'raise_mag_banner_options',
		'type'            => 'select',
		'choices'         => array(
			'banner_one' => esc_html__( 'Banner Layout One', 'raise-mag' ),
			'banner_two' => esc_html__( 'Banner Layout Two', 'raise-mag' ),
		),
		'active_callback' => 'raise_mag_is_active_banner',
	)
);

// Option - Banner Posts Category
$wp_customize->add_setting(
	'raise_mag_banner_posts_categories',
	array(
		'sanitize_callback' => 'raise_mag_sanitize_choices',
		'default'           => '',
	)
);

$wp_customize->add_control(
	new Raise_Mag_Dropdown_Multiple_Select(
		$wp_customize,
		'raise_mag_banner_posts_categories',
		array(
			'label'           => esc_html__( 'Select Post Category/Categories', 'raise-mag' ),
			'description'     => esc_html__( 'Select one or more than one categories', 'raise-mag' ),
			'section'         => 'raise_mag_banner_options',
			'type'            => 'select',
			'choices'         => raise_mag_categories_array(),
			'active_callback' => 'raise_mag_is_active_banner',
		)
	)
);

// Option - Banner Posts Number
$wp_customize->add_setting(
	'raise_mag_banner_posts_no',
	array(
		'sanitize_callback' => 'raise_mag_sanitize_number',
		'default'           => 5,
	)
);

$wp_customize->add_control(
	'raise_mag_banner_posts_no',
	array(
		'label'           => esc_html__( 'Number of Posts', 'raise-mag' ),
		'section'         => 'raise_mag_banner_options',
		'type'            => 'number',
		'active_callback' => 'raise_mag_is_active_banner',
	)
);

// Option - Banner Button Title
$wp_customize->add_setting(
	'raise_mag_banner_button_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '',
	)
);

$wp_customize->add_control(
	'raise_mag_banner_button_title',
	array(
		'label'           => esc_html__( 'Button Title', 'raise-mag' ),
		'section'         => 'raise_mag_banner_options',
		'type'            => 'text',
		'active_callback' => 'raise_mag_is_active_banner',
	)
);



/*
-----------------------------------------------------------------------------
							POST LISTING OPTIONS
-----------------------------------------------------------------------------*/

// Section - Blog Posts
$wp_customize->add_section(
	'raise_mag_post_listing_options',
	array(
		'priority' => 20,
		'title'    => esc_html__( 'Blog Posts Section', 'raise-mag' ),
	)
);

// Option - Banner Button Title
$wp_customize->add_setting(
	'raise_mag_post_button_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '',
	)
);

$wp_customize->add_control(
	'raise_mag_post_button_title',
	array(
		'label'   => esc_html__( 'Button Title', 'raise-mag' ),
		'section' => 'raise_mag_post_listing_options',
		'type'    => 'text',
	)
);


/*
-----------------------------------------------------------------------------
						FOOTER SECTION OPTIONS
-----------------------------------------------------------------------------*/

// Section - Footer
$wp_customize->add_section(
	'raise_mag_footer_options',
	array(
		'priority' => 20,
		'title'    => esc_html__( 'Footer Section', 'raise-mag' ),
	)
);

// Option - Enable Footer Social Links
$wp_customize->add_setting(
	'raise_mag_enable_footer_social_links',
	array(
		'sanitize_callback' => 'raise_mag_sanitize_checkbox',
		'default'           => 0,
	)
);

$wp_customize->add_control(
	'raise_mag_enable_footer_social_links',
	array(
		'label'   => esc_html__( 'Enable Footer Social Links', 'raise-mag' ),
		'section' => 'raise_mag_footer_options',
		'type'    => 'checkbox',
	)
);

// Option - Footer Copyright
$wp_customize->add_setting(
	'raise_mag_copyright_text',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '',
	)
);

$wp_customize->add_control(
	'raise_mag_copyright_text',
	array(
		'label'   => esc_html__( 'Copyright Text', 'raise-mag' ),
		'type'    => 'text',
		'section' => 'raise_mag_footer_options',
	)
);


/*
-----------------------------------------------------------------------------
							SOCIAL LINKS OPTIONS
-----------------------------------------------------------------------------*/

// Section - Social Links
$wp_customize->add_section(
	'raise_mag_social_link_options',
	array(
		'priority' => 20,
		'title'    => esc_html__( 'Social Links', 'raise-mag' ),
	)
);

// Option - Facebook Link
$wp_customize->add_setting(
	'raise_mag_facebook_link',
	array(
		'sanitize_callback' => 'esc_url_raw',
		'default'           => '',
	)
);

$wp_customize->add_control(
	'raise_mag_facebook_link',
	array(
		'label'   => esc_html__( 'Facebook Link', 'raise-mag' ),
		'section' => 'raise_mag_social_link_options',
		'type'    => 'url',
	)
);

// Option - Twitter Link
$wp_customize->add_setting(
	'raise_mag_twitter_link',
	array(
		'sanitize_callback' => 'esc_url_raw',
		'default'           => '',
	)
);

$wp_customize->add_control(
	'raise_mag_twitter_link',
	array(
		'label'   => esc_html__( 'Twitter Link', 'raise-mag' ),
		'section' => 'raise_mag_social_link_options',
		'type'    => 'url',
	)
);

// Option - Google Plus Link
$wp_customize->add_setting(
	'raise_mag_google_plus_link',
	array(
		'sanitize_callback' => 'esc_url_raw',
		'default'           => '',
	)
);

$wp_customize->add_control(
	'raise_mag_google_plus_link',
	array(
		'label'   => esc_html__( 'Google Plus Link', 'raise-mag' ),
		'section' => 'raise_mag_social_link_options',
		'type'    => 'url',
	)
);

// Option - Pinterest Link
$wp_customize->add_setting(
	'raise_mag_pinterest_link',
	array(
		'sanitize_callback' => 'esc_url_raw',
		'default'           => '',
	)
);

$wp_customize->add_control(
	'raise_mag_pinterest_link',
	array(
		'label'   => esc_html__( 'Pinterest Link', 'raise-mag' ),
		'section' => 'raise_mag_social_link_options',
		'type'    => 'url',
	)
);

// Option - Instagram Link
$wp_customize->add_setting(
	'raise_mag_instagram_link',
	array(
		'sanitize_callback' => 'esc_url_raw',
		'default'           => '',
	)
);

$wp_customize->add_control(
	'raise_mag_instagram_link',
	array(
		'label'   => esc_html__( 'Instagram Link', 'raise-mag' ),
		'section' => 'raise_mag_social_link_options',
		'type'    => 'url',
	)
);

// Option - VK Link
$wp_customize->add_setting(
	'raise_mag_vk_link',
	array(
		'sanitize_callback' => 'esc_url_raw',
		'default'           => '',
	)
);

$wp_customize->add_control(
	'raise_mag_vk_link',
	array(
		'label'   => esc_html__( 'VK Link', 'raise-mag' ),
		'section' => 'raise_mag_social_link_options',
		'type'    => 'url',
	)
);

// Option - Youtube Link
$wp_customize->add_setting(
	'raise_mag_youtube_link',
	array(
		'sanitize_callback' => 'esc_url_raw',
		'default'           => '',
	)
);

$wp_customize->add_control(
	'raise_mag_youtube_link',
	array(
		'label'   => esc_html__( 'Youtube Link', 'raise-mag' ),
		'section' => 'raise_mag_social_link_options',
		'type'    => 'url',
	)
);


/*
-----------------------------------------------------------------------------
							SIDEBAR OPTIONS
-----------------------------------------------------------------------------*/

// Section - Sidebar
$wp_customize->add_section(
	'raise_mag_sidebar_options',
	array(
		'priority' => 20,
		'title'    => esc_html__( 'Sidebar', 'raise-mag' ),
	)
);

// Option - Enable Sticky Sidebar
$wp_customize->add_setting(
	'raise_mag_enable_sticky_sidebar',
	array(
		'sanitize_callback' => 'raise_mag_sanitize_checkbox',
		'default'           => 0,
	)
);

$wp_customize->add_control(
	'raise_mag_enable_sticky_sidebar',
	array(
		'label'   => esc_html__( 'Enable Sticky Sidebar', 'raise-mag' ),
		'section' => 'raise_mag_sidebar_options',
		'type'    => 'checkbox',
	)
);

// Option - Sidebar Position
$wp_customize->add_setting(
	'raise_mag_global_sidebar_position',
	array(
		'sanitize_callback' => 'raise_mag_sanitize_select',
		'default'           => 'right',
	)
);

$wp_customize->add_control(
	'raise_mag_global_sidebar_position',
	array(
		'label'   => esc_html__( 'Global Sidebar Position', 'raise-mag' ),
		'section' => 'raise_mag_sidebar_options',
		'type'    => 'select',
		'choices' => array(
			'left'  => esc_html__( 'Left Sidebar', 'raise-mag' ),
			'right' => esc_html__( 'Right Sidebar', 'raise-mag' ),
			'none'  => esc_html__( 'No Sidebar', 'raise-mag' ),
		),
	)
);

/*
-----------------------------------------------------------------------------
							BREADCRUMB OPTIONS
-----------------------------------------------------------------------------*/

// Section - Breadcrumb
$wp_customize->add_section(
	'raise_mag_breadcrumb_options',
	array(
		'priority' => 20,
		'title'    => esc_html__( 'Breadcrumb', 'raise-mag' ),
	)
);

// Option - Enable Breadcrumb
$wp_customize->add_setting(
	'raise_mag_enable_breadcrumb',
	array(
		'sanitize_callback' => 'raise_mag_sanitize_checkbox',
		'default'           => 0,
	)
);

$wp_customize->add_control(
	'raise_mag_enable_breadcrumb',
	array(
		'label'   => esc_html__( 'Enable Breadcrumb', 'raise-mag' ),
		'section' => 'raise_mag_breadcrumb_options',
		'type'    => 'checkbox',
	)
);


/*
-----------------------------------------------------------------------------
							RELATED POSTS
-----------------------------------------------------------------------------*/

// Section - Related Posts
$wp_customize->add_section(
	'raise_mag_related_posts_options',
	array(
		'priority'    => 20,
		'title'       => esc_html__( 'Related Posts', 'raise-mag' ),
		'description' => esc_html__( 'Related posts are displayed in blog post page. Customize the related posts section with different options below.', 'raise-mag' ),
	)
);

// Option - Enable Related Posts
$wp_customize->add_setting(
	'raise_mag_enable_related_posts',
	array(
		'sanitize_callback' => 'raise_mag_sanitize_checkbox',
		'default'           => 0,
	)
);

$wp_customize->add_control(
	'raise_mag_enable_related_posts',
	array(
		'label'   => esc_html__( 'Enable Related Posts', 'raise-mag' ),
		'section' => 'raise_mag_related_posts_options',
		'type'    => 'checkbox',
	)
);

// Option - Related Posts Section Title
$wp_customize->add_setting(
	'raise_mag_related_posts_section_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '',
	)
);

$wp_customize->add_control(
	'raise_mag_related_posts_section_title',
	array(
		'label'           => esc_html__( 'Section Title', 'raise-mag' ),
		'section'         => 'raise_mag_related_posts_options',
		'type'            => 'text',
		'active_callback' => 'raise_mag_is_active_related_posts',
	)
);

// Option - Related Posts Number
$wp_customize->add_setting(
	'raise_mag_related_posts_no',
	array(
		'sanitize_callback' => 'raise_mag_sanitize_number',
		'default'           => 4,
	)
);

$wp_customize->add_control(
	'raise_mag_related_posts_no',
	array(
		'label'           => esc_html__( 'Number of Posts', 'raise-mag' ),
		'section'         => 'raise_mag_related_posts_options',
		'type'            => 'number',
		'active_callback' => 'raise_mag_is_active_related_posts',
	)
);


/*
-----------------------------------------------------------------------------
							AUTHOR SECTION
-----------------------------------------------------------------------------*/

// Section - Author Section
$wp_customize->add_section(
	'raise_mag_author_section_options',
	array(
		'priority'    => 20,
		'title'       => esc_html__( 'Author Info', 'raise-mag' ),
		'description' => esc_html__( 'Author description is displayed in blog post page. Customize the author section with different options below.', 'raise-mag' ),
	)
);

// Option - Enable Author Info
$wp_customize->add_setting(
	'raise_mag_enable_author_section',
	array(
		'sanitize_callback' => 'raise_mag_sanitize_checkbox',
		'default'           => 0,
	)
);

$wp_customize->add_control(
	'raise_mag_enable_author_section',
	array(
		'label'   => esc_html__( 'Enable Author Info', 'raise-mag' ),
		'section' => 'raise_mag_author_section_options',
		'type'    => 'checkbox',
	)
);


/*
-----------------------------------------------------------------------------
							OTHER OPTIONS
-----------------------------------------------------------------------------*/

// Section - Other
$wp_customize->add_section(
	'raise_mag_other_options',
	array(
		'priority' => 20,
		'title'    => esc_html__( 'Other Options', 'raise-mag' ),
	)
);

// Option - Default Excerpt Length
$wp_customize->add_setting(
	'raise_mag_excerpt_length',
	array(
		'sanitize_callback' => 'raise_mag_sanitize_number',
		'default'           => 20,
	)
);

$wp_customize->add_control(
	'raise_mag_excerpt_length',
	array(
		'label'       => esc_html__( 'Excerpt Length', 'raise-mag' ),
		'description' => esc_html__( 'Excerpt is the short post content. Excerpt length sets the number of words that the excerpt can contain. This is the default excerpt length used for other pages too.', 'raise-mag' ),
		'section'     => 'raise_mag_other_options',
		'type'        => 'number',
	)
);
