<?php
/**
 * Raise Mag functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Raise_Mag
 */

$current_theme = wp_get_theme( 'raise-mag' );

define( 'RAISE_MAG_VERSION', $current_theme->get( 'Version' ) );
define( 'RAISE_MAG_THEME_DIR', get_template_directory() );
define( 'RAISE_MAG_THEME_URI', get_template_directory_uri() );
define( 'RAISE_MAG_INC_DIR', get_template_directory() . '/inc/' );
define( 'RAISE_MAG_INC_URI', get_template_directory_uri() . '/inc' );



/* =====adding menu last and first class==========*/
function raise_mag_first_and_last_menu_class($items) {
	$items[1]->classes[] = 'first-menu';
	$items[count($items)]->classes[] = 'last-menu';
	return $items;
}
add_filter('wp_nav_menu_objects', 'raise_mag_first_and_last_menu_class');

/**
 * Include init for theme setup.
 */
require RAISE_MAG_THEME_DIR . '/inc/init.php';

