<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Raise_Mag
 */
$enable_social_links = get_theme_mod( 'raise_mag_enable_footer_social_links', 0 );

?>  
	<footer class="footer dark">
        <div class="ab_container">
        	<?php if( $enable_social_links == 1 ) : ?>
            <div class="vb_topfooter">
                <div class="social">
                    <ul class="social_icons_list">
                    	<?php 
                        $facebook_link = get_theme_mod( 'raise_mag_facebook_link', '' );
                        if( !empty( $facebook_link ) ) : ?>
                        <li><a href="<?php echo esc_url( $facebook_link ); ?>"><i class="fa fa-facebook" aria-hidden="true"></i> <?php esc_html_e( 'Facebook', 'raise-mag' ); ?></a></li>
                        <?php endif; ?>
                    	<?php
                        $twitter_link = get_theme_mod( 'raise_mag_twitter_link', '' );
                        if( !empty( $twitter_link ) ) : ?>
                        <li><a href="<?php echo esc_url( $twitter_link ); ?>"><i class="fa fa-twitter" aria-hidden="true"></i> <?php esc_html_e( 'Twitter', 'raise-mag' ); ?></a></li>
                        <?php endif; ?>
                    	<?php 
                        $googleplus_link = get_theme_mod( 'raise_mag_google_plus_link', '' );
                        if( !empty( $googleplus_link ) ) : ?>
                        <li><a href="<?php echo esc_url( $googleplus_link ); ?>"><i class="fa fa-google-plus" aria-hidden="true"></i> <?php esc_html_e( 'Google +', 'raise-mag' ); ?></a></li>
                        <?php endif; ?>
                    	<?php 
                        $pinterest_link = get_theme_mod( 'raise_mag_pinterest_link', '' );
                        if( !empty( $pinterest_link ) ) : ?>
                        <li><a href="<?php echo esc_url( $pinterest_link ); ?>"><i class="fa fa-pinterest" aria-hidden="true"></i> <?php esc_html_e( 'Pinterest', 'raise-mag' ); ?></a></li>
                        <?php endif; ?>
                    	<?php 
                        $instagram_link = get_theme_mod( 'raise_mag_instagram_link', '' );
                        if( !empty( $instagram_link ) ) : ?>
                        <li><a href="<?php echo esc_url( $instagram_link ); ?>"><i class="fa fa-instagram" aria-hidden="true"></i> <?php esc_html_e( 'Instagram', 'raise-mag' ); ?></a></li>
                        <?php endif; ?>
                    	<?php 
                        $vk_link = get_theme_mod( 'raise_mag_vk_link', '' );
                        if( !empty( $vk_link ) ) : ?>
                        <li><a href="<?php echo esc_url( $vk_link ); ?>"><i class="fa fa-vk" aria-hidden="true"></i> <?php esc_html_e( 'Vk', 'raise-mag' ); ?></a></li>
                        <?php endif; ?>
                    	<?php 
                        $youtube_link = get_theme_mod( 'raise_mag_youtube_link', '' );
                        if( !empty( $youtube_link ) ) : ?>
                        <li><a href="<?php echo esc_url( $youtube_link ); ?>"><i class="fa fa-youtube" aria-hidden="true"></i> <?php esc_html_e( 'Youtube', 'raise-mag' ); ?></a></li>
                        <?php endif; ?>
                    </ul><!-- .social_icons_list -->
                </div><!-- .social -->
            </div><!-- .vb_topfooter -->
        	<?php endif; ?>
        	<?php if( is_active_sidebar( 'footer' ) ) : ?>
            <div class="vb_midfooter">
                <div class="row">
                	<?php dynamic_sidebar( 'footer' ); ?>
                </div><!-- .row -->
            </div><!-- .vb_midfooter -->
        	<?php endif; ?>
        </div><!-- .ab_container -->
        <?php if( get_theme_mod( 'raise_mag_copyright_text', '' ) || has_nav_menu( 'footer-menu' ) ) : ?>
        <div class="vb_bottomfooter">
            <div class="ab_container">
                <div class="row">
                	<?php 
                	/**
                     * Hook - raise_mag_copyright_text.
                     *
                     * @hooked raise_mag_copyright_text_action - 1
                     */
                    do_action( 'raise_mag_copyright_text' ); 

                	/**
                     * Hook - raise_mag_footer_menu.
                     *
                     * @hooked raise_mag_footer_menu_action - 1
                     */
                    do_action( 'raise_mag_footer_menu' ); 
                	?>
                </div>
                <!-- // row -->
            </div>
            <!-- // ab_container -->
        </div><!-- .vb_bottomfooter -->
        <?php endif; ?>
    </footer><!-- .footer -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
