<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Raise_Mag
 */

get_header();
?>
	<div class="ab_container">
        <div class="mid_portion_wrap search_page_mid_wrap <?php echo esc_attr( raise_mag_main_post_list_class() ); ?>">
            <?php 
                /**
                 * Hook - raise_mag_breadcrumb.
                 *
                 * @hooked raise_mag_breadcrumb_action - 1
                 */
                do_action( 'raise_mag_breadcrumb' );
            ?>
            <div class="row">
                <?php raise_mag_global_left_sidebar(); ?>
                <div class="<?php echo esc_attr( raise_mag_post_list_class() ); ?>">
                    <div id="content" class="site-content">
                    <div id="primary" class="content-area">
                        <main id="main" class="site-main">
                            <?php if ( have_posts() ) : ?>
                            <div class="searchpage_entry">
                                <div class="page_title lined_page_title">
                                    <?php
                                    the_archive_title( '<h2 class="page-title">', '</h2>' );
                                    the_archive_description( '<div class="archive-description">', '</div>' );
                                    ?>
                                </div><!-- .page_title.lined_page_title -->
                                <div class="searchpage_contents_holder">
                                    <?php get_template_part( 'template-parts/archive/layout', 'grid' ); ?>
                                </div><!-- .searchpage_contents_holder -->
                            </div><!-- .searchpage_entry -->
                            <?php  
                            else :  
                                get_template_part( 'template-parts/content', 'none' );
                            endif;
                            ?>
                        </main><!-- #main.site-main -->
                    </div><!-- #primary.content-area -->
                 </div><!-- // site-content -->
                </div>
                <?php raise_mag_global_right_sidebar(); ?>
            </div><!-- .main row -->
        </div><!-- .mid_portion_wrap.search_page_mid_wrap -->
    </div><!-- .ab_container -->

<?php
get_footer();
