<?php
if (!class_exists('Quick_blog_Recent_Post_Widget')) {
    class Quick_blog_Recent_Post_Widget extends WP_Widget
    {

        private function defaults()
        {

            $defaults = array(
                'cat_id' => 0,
                'sub-title' => '',

            );
            return $defaults;
        }

        public function __construct()
        {
            parent::__construct(
                'quick-blog-recent-post-widget',
                esc_html__(' AT : Feature Widget', 'quick-blog'),
                array('description' => esc_html__(' Latest Blog Section', 'quick-blog'))
            );
        }

        public function form($instance)
        {
            $instance = wp_parse_args((array )$instance, $this->defaults());
            $catid = absint($instance['cat_id']);


            ?>




            <p>
                <label for="<?php echo esc_attr($this->get_field_id('cat_id')); ?>">
                    <?php esc_html_e('Select Category', 'quick-blog'); ?>
                </label><br/>
                <?php
                $business_con_dropown_cat = array(
                    'show_option_none' => esc_html__('From Recent Posts', 'quick-blog'),
                    'orderby' => 'name',
                    'order' => 'asc',
                    'show_count' => 1,
                    'hide_empty' => 1,
                    'echo' => 1,
                    'selected' => $catid,
                    'hierarchical' => 1,
                    'name' => esc_attr($this->get_field_name('cat_id')),
                    'id' => esc_attr($this->get_field_name('cat_id')),
                    'class' => 'widefat',
                    'taxonomy' => 'category',
                    'hide_if_empty' => false,
                );
                wp_dropdown_categories($business_con_dropown_cat);
                ?>
            </p>
            <hr>
            <?php
        }

        public function update($new_instance, $old_instance)
        {
            $instance = $old_instance;
            $instance['cat_id'] = (isset($new_instance['cat_id'])) ? absint($new_instance['cat_id']) : '';
            $instance['title'] = sanitize_text_field($new_instance['title']);

            return $instance;

        }

        public function widget($args, $instance)
        {
            echo $args['before_widget'];
            if (!empty($instance)) {
                $instance = wp_parse_args((array )$instance, $this->defaults());


                $catid = absint($instance['cat_id']);


                ?>
                <section id="quick-blog-theme-blog" class="">
                <div class="container">

                <div class="row">
                <div class="blog-list">
                <?php
                $i = 0;
                $sticky = get_option('sticky_posts');
                if ($catid != -1) {
                    $home_recent_post_section = array(
                        'ignore_sticky_posts' => true,
                        'post__not_in' => $sticky,
                        'cat' => $catid,
                        'posts_per_page' => 3,
                        'orderby' => 'post_date',
                        'order' => 'DESC',
                    );
                } else {
                    $home_recent_post_section = array(
                        'ignore_sticky_posts' => true,
                        'post__not_in' => $sticky,
                        'post_type' => 'post',
                        'posts_per_page' => 3,
                        'orderby' => 'post_date',
                        'order' => 'DESC',
                    );
                }

                $home_recent_post_section_query = new WP_Query($home_recent_post_section);

                if ($home_recent_post_section_query->have_posts()) {
                    while ($home_recent_post_section_query->have_posts()) {
                        $home_recent_post_section_query->the_post();
                        ?>
                        <div class=" boxed-wrapper clear-fix">
                        <!-- Link 1 -->
                        <div class="featured-link col-md-4">
                        <?php
                        if (has_post_thumbnail()) {
                            $image_id = get_post_thumbnail_id();
                            $image_url = wp_get_attachment_image_src($image_id, 'medium', true);
                            ?>
                            <img src="<?php echo esc_url($image_url[0]); ?>" alt="<?php the_title_attribute(); ?>">
                            <a href="<?php the_permalink(); ?>" class="customize-unpreviewable">
                                <div class="cv-outer">
                                    <div class="cv-inner">
                                        <h6><?php the_title(); ?></h6>
                                    </div>
                                </div>
                            </a>
                            </div>


                            </div>

                            <!-- end Single blog item -->
                            <?php
                            $i++;
                        }
                    } ?>

                    </div>
                    </div>
                    </div>
                    </section>

                    <?php
                    echo $args['after_widget'];
                }
            }
            wp_reset_postdata();

        }
    }

    add_action('widgets_init', 'quick_blog_recent_post_widget');
    function quick_blog_recent_post_widget()
    {
        register_widget('Quick_blog_Recent_Post_Widget');

    }

}