<?php
/*This file is part of Blog Mag, saraswati blog child theme.

All functions of this file will be loaded before of parent theme functions.
Learn more at https://codex.wordpress.org/Child_Themes.

Note: this function loads the parent stylesheet before, then child theme stylesheet
(leave it in place unless you know what you are doing.)
*/



function quick_blog_widgets_init()
{
    register_sidebar(array(
        'name'         => esc_html__('Feature Widget', 'quick-blog'),
        'id'           => 'feature-widget',
        'description'  => esc_html__('Add widgets Below Slider.', 'quick-blog'),
        'before_title' => '<h2 class="widget-title">',
        'after_title'  => '</h2>',
    ));


}
add_action('widgets_init', 'quick_blog_widgets_init');


function  quick_blog_remove_post_formats() {

    add_theme_support( 'post-formats', array( 'image','aside') );

}

add_action( 'after_setup_theme', 'quick_blog_remove_post_formats', 11 );

function quick_blog_about_section( $wp_customize ) {
    global $wp_customize;
    $wp_customize->remove_section('theme_detail');
}

add_action( 'customize_register', 'quick_blog_about_section' );

function quick_blog_slider_section( $wp_customize ) {
    global $wp_customize;
    $wp_customize->remove_section('saraswati-blog-feature-category');
}

add_action( 'customize_register', 'quick_blog_slider_section' );


if ( ! function_exists( 'quick_blog_scripts' ) ) :
    /**
     * Enqueue scripts and styles.
     */
    function quick_blog_scripts() {
        $quick_blog_theme_version = wp_get_theme()->get( 'Version' );
        $quick_blog_parent_theme_version = wp_get_theme(get_template())->get( 'Version' );

        /* If using a child theme, auto-load the parent theme style. */
        if ( is_child_theme() ) {
            wp_enqueue_style( 'quick-blog-style', get_template_directory_uri() . '/style.css', array(), $quick_blog_parent_theme_version );
        }
        wp_enqueue_script( 'jquery-masonry' );
        wp_enqueue_script('quick-blog-custom-masonary', get_stylesheet_directory_uri() . '/assets/js/custom-masonary.js', array('jquery'), '201765', true);

    }
endif;
add_action( 'wp_enqueue_scripts', 'quick_blog_scripts' );




/**
 * enqueue Admins style for admin dashboard.
 */



if ( !function_exists( 'quick_blog_admin_css_enqueue' ) ) :

    function quick_blog_admin_css_enqueue($hook)

    {
        if ($hook === 'widgets.php') {
            wp_register_script('quick-blog-page-widget-js', get_stylesheet_directory_uri() . '/assets/js/widget.js', array('jquery'), true);
            wp_enqueue_media();
            wp_enqueue_script('quick-blog-page-widget-js');

        }
         }
    add_action('admin_enqueue_scripts', 'quick_blog_admin_css_enqueue');
endif;





/*Write here your own functions */
require get_stylesheet_directory() . '/inc/widget/fearure-widget.php';





if ( !function_exists('saraswati_blog_default_theme_options') ) :
    function saraswati_blog_default_theme_options()
    {

        $default_theme_options = array(
            /*feature section options*/
            'saraswati-blog-feature-cat'             => 0,
            'saraswati-blog-theme-header-top-enable' => 1,
            'saraswati-blog-sticky-sidbar-enable'    => 1,
            'saraswati-blog-top-header-menu'         => 1,
            'saraswati-blog-header-social'           => 1,
            'saraswati-blog-post-meta'               => 0,
            'saraswati-blog-excerpt-lenght'          => 25,
            'saraswati-blog-footer-copyright'        => '',
            'saraswati-blog-layout'                  => 'right-sidebar',
            'saraswati-blog-featured-image'          => 'default',
            'saraswati-blog-meta-options'            => 1,
            'breadcrumb_option'                      => 'simple',
            'saraswati-blog-realted-post'            => 0,
            'saraswati-blog-continue-reading-options'=> esc_html__( 'Continue Reading', 'quick-blog' ),
            'saraswati-blog-realted-post-title'      => esc_html__( 'Related Posts', 'quick-blog' ),
            'saraswati-blog-single-featured-image'   => 1,
            'hide-breadcrumb-at-home'                => 1 ,
            'saraswati-blog-breadcrumb-text-option'  => esc_html__( 'You Are Here', 'quick-blog' ),
            'primary_color'                          => '#020b21',
            'slider_caption_bg_color'                => 'rgba(255,255,255,.9)',
            'hide-slider-post-at-category'           => 1,




        );

        return apply_filters( 'saraswati_blog_default_theme_options', $default_theme_options );
    }
endif;

/*updated to pro */


// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( !function_exists( 'chld_thm_cfg_locale_css' ) ):
    function chld_thm_cfg_locale_css( $uri ){
        if ( empty( $uri ) && is_rtl() && file_exists( get_template_directory() . '/rtl.css' ) )
            $uri = get_template_directory_uri() . '/rtl.css';
        return $uri;
    }
endif;
add_filter( 'locale_stylesheet_uri', 'chld_thm_cfg_locale_css' );

// END ENQUEUE PARENT ACTION
